7242 Introduction                                       The 7242 plug-in front panel controls allow     changing the timebase, the trigger conditions,    the signal amplifiers, and the display of a       summary of control settings on the mainframe      display.  Whenever a plug-in control is           changed, the plug-in's vertical and timebase      settings are briefly displayed on the screen.     The display indicates the settings to be used     for the next acquisition.  The labels             displayed next to the `MTRACE 1`N through         `MTRACE 8`N keys indicate the name or label of    the displayed trace and the acquisition           parameters used when the waveform was acquired    and are updated with every waveform               acquisition.                                        Note that changes to the control settings       will not be reflected in the displayed            waveform until the 7242 has acquired new data,    since changing the plug-in acquisition            settings has no effect on previously acquired     waveforms.  Therefore, the settings indicated     when controls are changed may differ from         those displayed next to the trace keys when       the 7200A is in the Single or Sequence Trigger    Mode and has finished acquiring data.         Display of Acquisition Parameters                       There are several displays which provide        parameter acquisition information.            Plug-in Status                                          The Plug-in Status screen displays all 7242     control settings.  The acquisition parameters     which do not have a dedicated control on the      front panel are changed from within this          screen.  Pressing the `MDISPLAY`N key or          pressing the `MMODIFY`N key (on the mainframe)    and the the `MDISPLAY`N key  brings up the        Plug-in Status screen.                              The acquisition parameters which do not have    a dedicated control on the front panel can be     changed from within this menu.  To select the     parameter to change, rotate the `MModify          Field`N soft knob until the box moves to the      item to be changed.  To change the item's         value, rotate the `MModify Value`N soft knob      until your choice appears within the box.  The    list of choices are shown in the lower right      corner of the menu, with the current choice in    the center of the list of options.                  The screen is divided into three main           sections:  Trigger Controls, Timebase             Controls, and Vertical Controls.              Vertical Status Screen                                  The Vertical Status screen contains a sub-      set of the control settings shown in the          Plug-in Status display so that the waveforms      can be viewed while the acquisition controls      are being changed.  The Vertical Status screen    appears when you press the `MMODIFY`N key and     then press any key or rotate any knob in the      vertical section on the plug-in's front panel     or when selected from inside the Trigger or       Timebase status screens.                      Trigger Status Screen                                   The Trigger Status screen contains a sub-set    of the control settings shown in the Plug-in      Status display so that the waveforms can be       viewed while the acquisition controls are         being changed.  The Trigger Status screen         appears when you press the `MMODIFY`N key and     then press any key or rotate any knob in the      trigger section on the plug-in's front panel      or when selected from inside the Timebase or      Vertical status screens.                      Timebase Status Screen                                  The Timebase Status screen contains a sub-      set of the control settings shown in the          Plug-in Status display so that the waveforms      can be viewed while the acquisition controls      are being changed.  The Timebase Status screen    appears when you press the `MMODIFY`N key and     then press any key or rotate any knob in the      timebase section on the plug-in's front panel     or when selected from inside the Vertical or      Trigger status screens.                       Plug-in Controls                                        The following sections will describe all the    controls available to the user.               Vertical Controls                                       The Vertical controls adjust signal             amplification for each plug-in channel.  These    adjustments are made either with dedicated        front panel controls or from within the Plug-     in or Timebase Status screens.                      The `MCH1`N or `MCH2`N keys select which        channel the Vertical controls will modify. For    example, when CH1 is pressed, adjusting a         Vertical control will affect CH1 signal input.    CH2 settings remain unchanged.  The channels      LED next to the key is lit to indicate the        selected channel.                                   The `MSelect All Channels`N softkey is          located in the Plug-in and Vertical status        screens and is used to set all the vertical       control settings for every channel of the         plug-in to be the same as the vertical control    settings for the channel indicated to the         right of the "Vertical Controls" label.  Both     the CH1 and CH2 led's will be lit and             modifiying any vertical controls will affect      CH1 and CH2's signal input.                         The `MV/DIV`N (Volts/Division) knob selects     the vertical sensitivity factor in multiples      of 1, 2, and 5.  The sensitivity range is 5 mV    to 1 V/div at both 1 M and 50  input            impedances with the variable sensitivity (as      described later) set to unity.                      The `MVariable Gain`N Knob provides a           variable vertical sensitivity within the V the    vertical range up to 2.5 times the V led is       lit next to the knob when the sensitivity is      between fixed settings.                             Pressing the `MVAR`N key toggles between 1.0    times the V currently selected Variable Gain      setting.  An LED next to the `MVAR`N key is       lit to indicate that the Variable Gain is         selected.  The Combined Volts/div and Variable    Gain settings for CH 1 and CH 2 are displayed     in the Status Message Field for about ten         seconds while any control is adjusted.              `MProbe Attenuation`N indicates the probe       attenuation factor included in the vertical       sensitivity indicators. If attenuation-coded      probes are used, the probe contact rings          surrounding the CH1 and CH2 BNC connectors        recognize the attenuation factors of the          probes. If this type of probe is not used, the    probe attenuation can be selected in the          Plug-in Status screen or the Vertical Status      screen.  The choices are x1 to x1000.           Total V/Div                                           Total V/Div indicates the current setting of    the front panel Vertical Sensitivity control      multiplied by the variable sensitivity and the    probe attenuation.  Variable sensitivity is       adjusted (up to x2.5 of the V/Div setting)        with the `MVAR`N knob inside of the `MV/Div`N     knob.                                           Probes                                                Two Model 7200-P12 passive probes are           supplied with the 7242.  These probes have 1      M input impedance and approximately 15 pF        capacitance.  The system bandwidth with 7200-     P12 probes is DC to 250 MHz (typical) with        1M DC coupling, and less than 10 Hz to 250       MHz in AC coupling.                             Probe Calibration                                     To calibrate the 7200-P12 Probe, connect it     to the BNC connector labeled CH 1 or CH 2.        Connect the probe's grounding alligator clip      to the front panel ground lug of the              oscilloscope and connect the tip to the signal    lug.  Use the `MAuto Setup`N key to obtain a      signal.  If over- or undershooting of the         displayed signal occurs, it is possible to        adjust the 7200-P12 Probe by inserting the        small screwdriver supplied with the probe         package into the trimmer on the probe's           barrel.  Turn the screwdriver either clockwise    or counter-clockwise to achieve the optimal       square wave contour.                            Input                                                 BNC type connectors are used for both CH 1      and CH 2 signal inputs, and the external          trigger connector marked EXT TRIG.  The           maximum permissible input voltage is 250 V (DC    + peak AC) in 1 M.                                 The `MCOUPLING`N keys select the method used    to couple the signal to the vertical amplifier    input.  Sequentially press key to select one      of four types of input coupling.  LED's to the    left of the `MCOUPLING`N keys indicate the        selection.  Possible selections are as            follows:                                          AC    with 1 M input impedance                   DC    with 1 M input impedance,                  GND   (appears open, as seen from the input               connector), and                           DC with 50  impedance.                             In the AC position, signals are coupled         capacitively, thus blocking the input signal's    DC component and limiting the signal              frequencies to more than 10 Hz.                     The maximum dissipation into 50  is 0.5        W, and signals will automatically be              disconnected whenever this level is exceeded.     A warning LED (OVLD) lights up indicating when    an overload condition has been detected.  The     input coupling is simultaneously switched to      GND.  The overload condition is reset by          removing the signal from the input and re-        selecting the desired input impedance again.        The `MOFFSET`N knob adjusts the voltage         offset used to position the signal within the     amplifier's input range.  The maximum offset      is > 12 times the fixed sensitivity setting       and is manually adjustable (or programmable)      in 0.02 division increments.  A pair of           upward- or downward-pointing arrows ( or         ) on the grid's upper or lower edge              indicate when the trace has been positioned       outside of the grid.                                The `MZero Offset`N key toggles between zero    offset and the currently selected offset          value.  An LED next to the key lights "ZERO"      to indicate zero offset.                            The `MBandwidth Limit`N field in the Plug-in    or Vertical Status screen can be used to          reduce the bandwidth from 400 MHz (500 MHz for    7242A) to 95 MHz in 50  and from 250 MHz         to 95 MHz in 1 M. This reduction in              bandwidth is achieved with an analog hardware     lowpass filter, before the digitizer, and is      useful in reducing system noise in cases where    the signal frequency components are below 95      MHz.  The filter rolls off at about -18dB per     octave (3-pole).                                    The `MEnhanced Res`N field in the Plug-in       and Vertical Status screens allows the user to    select the amount of digital filtering for        enhancing resolution. By reducing the system      bandwidth, both noise and signal above the        cutoff are effectively removed from the           resulting waveform. If the signal components      of interest are below the cutoff, then the        effective resolution can be improved beyond       the ADC's ideal resolution.  Selecting greater    values of this parameter, results in              progressively lower system bandwidths. Since      the ADC's each have 8 bits, selecting the         lowest value (8.0) removes the filter.            Indicated next to the number of bits is the       effective system bandwidth (calculated from       the theoretical filter bandwidth and the          unfiltered analog bandwidth.  Because extra       samples before and after the resulting            waveform record are required to do the digital    filtering, Enhanced Res cannot be used when       the trigger mode is Sequence.                       The `MOpt Pulse Resp`N field in the Plug-in     and Vertical Status screens allows the user to    select the type of low-pass filter applied to     data that was digitized at 2GS/s. Optimal         pulse response is achieved with a filter that     rolls of slowly from the maximum analog           bandwidth to 1GHz. When this field is set to      "NO" a filter with much steeper roll-off is       applied to the data providing better effective    bit performance.                              Timebase Controls                                       Timebase controls allows the user to select     the horizontal parameters used to acquire         data.  These parameters are Timebase, Random      Interleaved Sampling, Max Memory, Sampling,       Clock (source), and if in sequence trigger        mode the Number of Segments.                        The `MTIMEBASE`N knob is used to select the     amount of time each horizontal division           represents.  The Timebase setting, the Max        Memory, and if in sequence mode, the number of    segments determines the sampling frequency and    the number of sample points displayed per         division. The detented knob selects the           Timebase in a 1-2-5 sequence from 200 ps/DIV      to 10,000 sec/DIV.  The number of Point/div       and the Time/point is dispalyed in the Plug-in    status or Timebase Status screens. Depending      on the timebase setting, the following three      sampling modes are selectable: Random             Interleaved Sampling (RIS), Single Shot, and      Sequence.                                           The `MRandom Interleaved Sampling (RIS)`N       key turns on or off RIS acquisition mode          depending on the timebase setting. For the        7242, the RIS acquisition consists of many        single-shot acquisitions at 200 MS/s, each        with about 1/100th of the final Memory size.      For each acquisition the time between the         actual trigger signal and the next sampling       clock is recorded, and used to associate the      single-shot acquisition with one of 100           "leaves". When there is an acquisition for        each of 100 "leaves", the single-shot             waveforms are "interleaved" to form a RIS         waveform, with effectively 100 times the          single-shot sampling rate, or in this case 20     GS/s.  Because the triggers are randomly          associated with the sampling process              (uncorrelatd with the sampling clock), the        word random is used in Random Interleaved         Sampling.  This method requires repetitive        signal source, a stable trigger and a rep-rate    not correlated with the 200MS/s sample clock.       It is interesting to note that considerably     more than 100 randomly correlated triggers are    required to fully populate the 100 RIS leaves.    Based on statistical arguments, the nominal       factor is between 5 and 6 times for 100 leaves    (i.e. 500 to 600 triggers), but as many as 10     times is not impossible. Since the trigger        times are random, even though a 50 picosecond     spacing between leaves is used, each              individual leaf could have an error as large      as +- 25 picoseconds. The 7242 uses the "best"    100 acquisitions to form a RIS record (i.e. if    a newly acquired trigger has a smaller error      than the previously acquired trigger for that     leaf, the acquisition with the smallest error     is used. No averaging is done; nominally 80%      of the acquisitions are discarded.                  At timebase settings from 200 ps/DIV to 5       nsec/div, the 7242 automatically uses the RIS     mode for signal acquisition. When selected, an    "ON" led on the 7242 front-panel will be lit,     otherwise, the "ON" led is not lit and            single-shot acquisitions are used.  If the Max    Memory is set to 2K, RIS or single-shot may be    selected in the range 5nsec/div and               10nsec/div.  If the memory size is set to 20K,    RIS or single shot may be selected in the         range 5nsec/div and .1 sec/div.  If the          memory size is set to 50K, RIS or single shot     may be selected in the range 5nsec/div and .1     sec/div.  The 7242 can record waveforms in       a single-shot acquisition for timebase            settings between 5 nsec and 200 msec/div.         Sampling rates up to 1 gigasamples/sec are        possible in the single-shot mode.                   Two `MSampling`N options are available in       RIS mode, RANDOM and INTERPOLATED.  RIS data      has inherently non-uniform sampling intervals.    Because RIS waveforms are generally highly        oversampled (i.e. the effective sample rate is    many times higher than the signal bandwidth)      the non-uniformity of sample spacing has          subtle implications. The INTERPOLATED Sampling    option uses a linear interpolation algorithm      and the nearest neighboring samples to create     a RIS record with uniform sampling intervals.     The RANDOM option does not perform this           interpolation. INTERPOLATED is generally the      most useful choice. However in cases where the    fundamental assumptions of RIS sampling are in    question (not truly repetitive signal), RANDOM    Sampling is preferred. For example, if            Persistence Display is to be used to analyse      varying timing, and the timebase selection is     such that RIS is required, then RANDOM            Sampling should be used. Eye Diagram analyses     are inherently non-repetitive, and care must      be taken in attempting this kind of analysis      with RIS acquisition.                               When waveform parameters are computed on an     incomplete RIS record, and INTERPOLATED           Sampling has been chosen, the missing points      are filled in using linear interpolation. This    is not done when RANDOM Sampling is in effect.    The interpolated data are only used for the       parameter computations.  The original data are    used for waveform processing, display, and        output.                                             `MNumber of Segments`N is a selectable field    in the Plug-in and Timebase Status screens        when the trigger mode is Sequence.  The Number    of segments indicates the number of segments      in a sweep.  The number of segments, the          timebase setting, and the acquisition memory      size determine the number of data points per      segment and the time per point which is           displayed in the Plug-in and Timebase status      screens.  Number of segments can be selected      from 2 to 200 segments.                             The `MMax Memory`N field appears in the         Plug-in and Timebase Status screens and allows    the user to specify the maximum number of         points to represent each waveform.  Together      with the timebase setting (and if in Sequence     mode, the number of segments), it determines      the the segment length and the time per point.    The choices are 1K, 2K, 5K, ..., 50K points.      Acquire 1,000 samples to achieve maximum          waveform throughput. Obtaining 50,000 points,     provides a greater window of the signal,          requiring more time to process the additional     points.                                         Points/div                                            Indicates the number of samples in each         division of the display grid, provided the        waveform is not decimated or expanded.          Time/point                                            Indicates the sample rate or the time           between digitized sample points for the           corresponding timebase setting.                     The `MClock`N field appears in the Plug-in      and Timebase Status screens and allows the        user to specify whether to used the Plug-in's     internal clock or an external clock which is      applied to the 7200A's rear panel.  With an       external clock, the suggested clock rate is       specified.  The maximum sample rate is 1          gigasample.                                   Trigger Controls                                        The 7242 offers two independent triggering      methods: Standard and Smart Trigger.  Standard    trigger provides basic trigger functions which    can be controlled from the front panel.  Smart    Trigger adds additional qualifications to the     trigger source(s). The Smart Trigger key on       the plug-in front panel toggles between           selecting either method.  The LED indicates       when Smart Trigger is selected.  Smart Trigger    options can be adjusted either with dedicated     front panel controls or from within the Plug-     in or Trigger Status screens.                       The pair of `MSOURCE`N keys enable trigger      source selection as follows:                      CH 1    Selects Channel 1 as the trigger                  source, i.e., the signal connected to             the Channel 1 BNC input connector.        CH 2    Selects Channel 2 as the trigger                  source, i.e., the signal connected to             the Channel 2 BNC input connector.        Ext     With the Trigger source set to EXT, a             signal applied to the BNC connector               labeled "EXT TRIG" is used to trigger             the scope within a range of  2 V.        Ext/10  With the Trigger source set to EXT/10,            a signal applied to the BNC connector             labeled "EXT TRIG" is used to trigger             the scope within a range of  20 V.       Line    Selects the line voltage which powers             the oscilloscope to provide a stable              display of signals synchronous with               the power line.                             When EXT or EXT/10 is selected as the           trigger source, a signal applied to the BNC       connector labelled EXT TRIG can be used to        trigger the scope when the signal is between       2 V.  This BNC input accepts an external        trigger signal bias of up to  250 VDC.           Input impedance is 1 M in parallel with          <<30 pF.                                            The `MCOUPLING`N keys select the type of        signal coupling at the input of each trigger      circuit.  Note that the trigger coupling can      be adjusted independently for each trigger        source.  Therefore, a change of the trigger       source may also result in a change of the         trigger coupling LEDs since the coupling          associated with the newly selected source is      remembered.  The types of coupling are as         follows:                                          AC      Signals are capacitively coupled; DC               Levels are rejected and frequencies               below 8 Hz are attenuated.               LF REJ  Signals are DC coupled to the trigger              circuit and a low-pass filter network             attenuates frequencies above 50 kHz.              The LF trigger mode is used to                    trigger on low frequency signals.        HF REJ  Signals are coupled via a capacitive               high-pass filter network.  DC is                  rejected and signal frequencies below             50 kHz are attenuated. The HF trigger             mode is used to reject high frequency             signals.                                 DC      All of the signal's frequency                      components are coupled to the trigger             circuit.                                   The `MDELAY`N field is used to select the       function of the delay knob.  The choices are      TIME and PERCENT.  When delay is set as a         function of TIME, the delay knob adjusts the      amount of time the signal is recorded             before(pre_trigger) or after(post trigger) the    trigger occurs.  When delay unit is set to        PERCENT, the trigger delay can be positioned      any where on the screen and will remain           constant as the time per division is changed.       The `MDELAY`N knob is used to select the        Trigger Delay.  `MDELAY`N adjusts the amount      of signal recorded before(pre-trigger) or         after(post-trigger) the trigger occurs.  The      pre-trigger amount depends on the Timebase,       memory size, and if in Sequence trigger mode,     the number of segments.  The delay can be         adjusted in time or as a percentage of the        screen. The maximum limit is 10,000 record        lengths.  The arrow under the grid indicates      the trigger point of the displayed trace.         Trigger delay is locked to other plug-ins when    the timebase controls are locked.                   The `MZero Delay`N key toggles between the      selected delay setting and a trigger delay of     0.0 sec or 50 %, which would put the trigger      at the center of the grid. An LED next to the     key lights "ZERO" to indicate zero trigger        delay. Trigger delay is locked to other plug-     ins when the timebase controls are locked.          The `MLEVEL`N knob adjusts the voltage level    at which trigger will occur.  When the trigger    level is increased, the trigger circuit will      respond at a higher voltage level. If vertical    sensitivity is adjusted such that the             previously selected trigger level exceeds the     sensitivity range, then the trigger level is      automatically reduced to fit the new range.       The range of trigger levels is as follows:        Trigger Source  Trigger Range                     CH 1 or 2       +-5 screen divisions *                                total gain                    LINE            none (zero-crossing is used)      EXT             +-2 Volts                         EXT/10          +-20 Volts                          The `MZero Level`N key toggles between the      selected trigger level and a trigger level of     0.0 Volts. An LED next to the key lights          "ZERO" to indicate zero trigger level.              The `MSLOPE`N key selects the signal edge       used to activate the trigger circuit.  The        slope of the trigger can be adjusted for each     individual trigger source and is indicated by     LEDs above the `MSLOPE`N key.                     POS        Triggers on a positive-going edge.     NEG        Triggers on a negative-going edge.       The Trigger Slope setting is not used if the    trigger source is Line.                             A READY LED on each plug-in indicates that      the trigger circuit has been armed and the        plug-in is currently acquiring input signals.     The TRIG'D LED is lit whenever the time base      is stopped (normally after a valid trigger).        The `MSmart Trigger`N key toggles between       selecting the Standard Trigger and the Smart      Trigger.  Smart Trigger is setup from within      the Plug-in and Trigger status screens. An LED    next to the key will light "ON" to indicate       Smart Trigger is selected.  Smart Trigger         offers a variety of trigger qualifications        based on the ability of the 7242 to :               - To count a specified number of events(1 to    15,000,000)                                         - To measure time intervals(1 nsec up to 680    sec)                                                - To recognize a pattern input to the           selected trigger sources.  When Smart Trigger     is selected one of five triggering methods can    be selected:                                        `MSingle Source`N - Trigger on the selected     source when the trigger conditions and one of     the following qualifications are met:               - Holdoff for 30 nsec up to 680 sec.              - Holdoff for 1 to 15,000,000 events.             - Interval < 30 nsec up to 680 sec.               - Interval > 30 nsec up to 680 sec.               - Pulse < 1 nsec up to 680 sec.                   - Pulse > 1 nsec up to 680 sec.                   `M.`N                                             - Trigger whenever the selected combination     of signals occurs and one of the following        qualifications are met:                             - Holdoff for 30 nsec up to 680 sec.              - Holdoff for 1 to 15,000,000 events.             - Interval < 30 nsec up to 680 sec.               - Interval > 30 nsec up to 680 sec.               - Time between patterns < trigger                 on entering(1 nsec up to 680 sec).                - Time between patterns > trigger on              entering(1 nsec up to 680 sec).                   - Pattern width < trigger on exiting              (1 nsec up to 680 sec).                           - Pattern width > trigger on exiting              (1 nsec up to 680 sec).                           `MState Qualified`N - Trigger whenever the      trigger source meets its trigger condition        during the selected pattern and one of the        following qualifications are met:                   - Wait for 10 nsec up to 680 sec.                 - And Before 10 nsec up to 680 sec.               - Trigger on 1 to 15,000,000 events.              `MTime Qualified`N - Trigger whenever the       trigger source meets its trigger condition        after the selected combination and one of the     following qualifications are met:                   - Wait for 10 nsec up to 680 sec.                 - And Before 10 nsec up to 680 sec.               - Trigger on 1 to 15,000,000 events.              `MTV`N - Trigger on the selected horizontal     scan line of the composite sync signal            connected to the EXT trigger input.  The          following qualifications can be selected:           - Select the horizontal scan line from 10 to    2500 to trigger on                                  - Select the frame the line is selected         from. The choices are `MEVEN FRAME`N , `MODD      FRAME`N , or `MBOTH FRAMES`N                        - Select the horizontal scan rate. The          choices are 15 to 20 Khz,                             20 to 30 KHz, or 30 to 63 KHz.                  The `MHF Sync`N field appears in the Plug-in    and Trigger Status screens and allows the user    to turn on and off the Hi Freq Sync.  When HF     Sync is ON, the trigger source has its            frequency rate divided.  Select ON to allow       stable triggering for sources greater than 200    MHz.  When HF Sync is ON, the trigger slope is    always positive regardless of what was            previously selected.  HF Sync can not be used     with Smart Trigger.                           Calibrate                                               The `MCalibrate`N key ensures overall           vertical, timebase, and trigger accuracy by       calibrating the plugin at it's cuurent            setting.  Calibration is also performed when      the 7200A is powered, when Timebase or            Vertical Controls are adjusted, and               periodically thereafter.  There is a calibrate    softkey located in all Status screens. The        7291 adapter can be calibrated by pressing the    modify key before pressing the calibrate          softkey whenever a 7291 adapter is attached.  